window.onload = function () { // wait for code execution until page is fully loaded

    // collapsibles dropdown functionality
    var coll = document.getElementsByClassName("collapsible");
    var i;
    for (i = 0; i < coll.length; i++) {
        coll[i].addEventListener("click", function() {
            this.classList.toggle("collapsibleActive");
            var content = this.nextElementSibling;
            if (content.style.maxHeight){
                content.style.maxHeight = null;
            } else {
                content.style.maxHeight = content.scrollHeight + "px";
            } 
        });
        coll[i].click(); // expand all collapsibles
    }


    // selectable tables functionality
    var tables = document.getElementsByClassName('selectableTable');
    for (var t = 0; t < tables.length; t++) {
        var table = tables[t];
        var cells = table.getElementsByTagName('td');
        for (var c = 0; c < cells.length; c++) {
            var cell = cells[c];   
            cell.onclick = function () {
                var rowId = this.parentNode.rowIndex;
                var headers = this.parentElement.parentElement.parentElement.getElementsByTagName('th');

                if (headers.length > 0) {
                    // table contains headers
                    rowId = rowId-1;
                }

                var rowsAll = this.parentElement.parentElement.getElementsByTagName('tr');
                var rowSelected = this.parentElement.parentElement.getElementsByTagName('tr')[rowId];

                if (rowSelected.classList.contains('trselected') == false) {
                    // remove all and select current
                    for (var row = 0; row < rowsAll.length; row++) {
                        rowsAll[row].classList.remove("trselected","showTooltip");
                    }
                    rowSelected.classList.add("trselected","showTooltip");
                } else {
                    // remove current
                    rowSelected.classList.remove("trselected","showTooltip");
                }
            }
        }
    }

    // magnifiy images
    var imgs = document.getElementsByClassName('magnifyImage');
    for (var im = 0; im < imgs.length; im++) {
        var img = imgs[im];

        img.onclick = function () {
            magnifyStop();
            if (this.classList.contains('magnOn') == false) {
                this.classList.add("magnOn");
                magnifyStart(this, 3);
            }
            else {
                this.classList.remove("magnOn");
            }
        }        
    }

}

function magnifyStart(img, zoom) {
    var glass, w, h, bw;
    //img = document.getElementById(imgID);
    /*create magnifier glass:*/
    glass = document.createElement("DIV");
    glass.setAttribute("class", "magnifierGlass");
    glass.onclick = function () {
        img.classList.remove("magnOn");
        magnifyStop ()};
    /*insert magnifier glass:*/
    img.parentElement.insertBefore(glass, img);
    /*set background properties for the magnifier glass:*/
    glass.style.backgroundImage = "url('" + img.src + "')";
    glass.style.backgroundRepeat = "no-repeat";
    glass.style.backgroundSize = (img.width * zoom) + "px " + (img.height * zoom) + "px";
    glass.style.visibility = "hidden";
    bw = 1;
    w = glass.offsetWidth / 2;
    h = glass.offsetHeight / 2;
    /*execute a function when someone moves the magnifier glass over the image:*/
    glass.addEventListener("mousemove", moveMagnifier);
    img.addEventListener("mousemove", moveMagnifier);
    /*and also for touch screens:*/
    glass.addEventListener("touchmove", moveMagnifier);
    img.addEventListener("touchmove", moveMagnifier);
        
    function moveMagnifier(e) {
        var pos, x, y;
        /*prevent any other actions that may occur when moving over the image*/
        e.preventDefault();
        /*get the cursor's x and y positions:*/
        pos = getCursorPos(e);
        x = pos.x;
        y = pos.y;
        /*prevent the magnifier glass from being positioned outside the image:*/
        if (x > img.width - (w / zoom)) {x = img.width - (w / zoom);}
        if (x < w / zoom) {x = w / zoom;}
        if (y > img.height - (h / zoom)) {y = img.height - (h / zoom);}
        if (y < h / zoom) {y = h / zoom;}
        /*set the position of the magnifier glass:*/
        glass.style.left = (x - w) + "px";
        glass.style.top = (y - h) + "px";
        /*display what the magnifier glass "sees":*/
        glass.style.backgroundPosition = "-" + ((x * zoom) - w + bw) + "px -" + ((y * zoom) - h + bw) + "px";
        glass.style.visibility = "visible";
    }
    
    function getCursorPos(e) {
        var a, x = 0, y = 0;
        e = e || window.event;
        /*get the x and y positions of the image:*/
        a = img.getBoundingClientRect();
        /*calculate the cursor's x and y coordinates, relative to the image:*/
        x = e.pageX - a.left;
        y = e.pageY - a.top;
        /*consider any page scrolling:*/
        x = x - window.pageXOffset;
        y = y - window.pageYOffset;
        return {x : x, y : y};
    }
}

function magnifyStop() {
    var imgs = document.getElementsByClassName('magnifyImage');
    for (var im = 0; im < imgs.length; im++) {
        var img = imgs[im];
        img.classList.remove("magnOn")
    }
    var magnGls = document.getElementsByClassName('magnifierGlass');
    for (var mg = 0; mg < magnGls.length; mg++) {
        var cmg = magnGls[mg];
        cmg.parentNode.removeChild(cmg);
    }
}